/****************************************************************************/
/*
** scntype.h
**
** Common Scanner Types
*/
/****************************************************************************/
#if !defined(_SCNTYPE_H_)
   #define _SCNTYPE_H_

/*==========================================================================*/
/*
** Fundamental Types
*/
/*--------------------------------------------------------------------------*/

typedef signed char             S8;
typedef short                   S16;
typedef int                     S32;
typedef long                    S40;

typedef unsigned char           U8;
typedef unsigned short          U16;
typedef unsigned int            U32;
typedef unsigned long           U40;

typedef int                     Boolean;

//Different image interlacing possibilities
#define IMG_INTERLACE_NONE     ( 1 << 1 )
#define IMG_INTERLACE_LEFT     ( 1 << 2 )
#define IMG_INTERLACE_RIGHT    ( 1 << 3 )
#define IMG_INTERLACE_TOP      ( 1 << 4 )
#define IMG_INTERLACE_BOTTOM   ( 1 << 5 )
#define IMG_HYPERFRAME         ( 1 << 6 )

// Size of finger arrays
#define FNGR_ARR_SIZE 4

struct t_Img_Info
/*
** Organizes information about an image.
*/
{
U32                     tag;            /* image group tag                  */
U32                     scan;           /* scan designation                 */
U32                     type;           /* type of image indicator          */

U32                     height;         /* lines in image                   */
U32                     width;          /* pixels per line                  */
U32                     pitch;          /* bytes of storage per line        */
U32                     depth;          /* bits per pixel                   */
U32                     v_res;          /* vertical resolution (dpi)        */
U32                     h_res;          /* horizontal resolution (dpi)      */

U8*                     data;           /* image storage (u/l corner)       */

U32                     interlace;      /* interlace info                   */
U8    ucDarkenValue;  // value for darkening the display image
U8    ucStartThres;   // point to start modifying the display
U8    ucUpperLimit;   // All pixel values above this will be set
                      // max white
U8    ucBase;         // used for realtime equalization
};
typedef struct t_Img_Info       Img_Info;

/*
** Structure to store all available information about the current raw image
*/
typedef struct
{
   S16 sTopLine;      // Start line of image area    
   U16 sNoOfLines;    // Number of lines within image area
   U16 sLeftMargin;   // Start pixel of the image area 
   U16 sWidth;        // Width of the image
}s_Image;

/* Type of slap detected */
typedef enum{
   eRT_SLAP_DETECTION_FNGR_IN_GAP= -5,
   eRT_SLAP_DETECTION_NOT_IMPLEMENTED=-1,
   eRT_SLAP_DETECTION_UNKNOWN = 0,
   eRT_SLAP_DETECTION_LEFT_HAND,
   eRT_SLAP_DETECTION_RIGHT_HAND,
   eRT_SLAP_DETECTION_TWO_THUMBS,
   eRT_SLAP_DETECTION_SINGLE_FNGR,
   eRT_SLAP_DETECTION_THREE_FNGRS
}e_RtSlapDetected;

/*  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  */
/*
** Related Constants
*/
/*  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  */

   #define   MAX_S8    ((S8)0x7F)
   #define   MIN_S8    ((S8)0x80)
   #define   MAX_S16   ((S16)0x7FFF)
   #define   MIN_S16   ((S16)0x8000)
   #define   MAX_S32   ((S32)0x7FFFFFFF)
   #define   MIN_S32   ((S32)0x80000000)

   #define   MAX_U8    ((U8)0xFF)
   #define   MAX_U16   ((U16)0xFFFF)
   #define   MAX_U32   ((U32)0xFFFFFFFF)

   #define   U8_BITS   8

   #if !defined(TRUE)
      #define   TRUE      ( 1 == 1)
   #endif
   #if !defined(FALSE)
      #define   FALSE     ( 1 == 2) 
   #endif

/****************************************************************************/
#endif /*_SCNTYPE_H_*/
